/*************************************************************************/
/*
Inhalt
         1.0  : Simulator.c
         1.1. Imports                                                               
         1.2 Globals  
         1.2.1 Prototypes of Functions
         2.0 Locals    
         3.  Modul Routinen ControlControl    
         3.1 Function    : Init       
         3.2 Function    : f              
         3.4 Functions   : Timer             
         3.5 Function    : fSetGet_System                 
         4.1 ISR Routine : ISR_SimulatorTask()     
         5.0 Task        : sCycleSimulator()                                                  
*/
/*************************************************************************/
/*                                                                       */
/* Name     
         1.0  : TeleskopControl.c             Version in project: 001     */
/*                                              // !!! update please !!! */
/* Author     : Volker Pritsching                                        */
/*                                                                       */
/* Language   : C                                                        */
/*                                                                       */
/* Description: Kleinsteuerung f r Telekope version: VX00A vpr           */
/*              Bitte hier eine Beschreibung eintragen                   */
/*                                                                       */
/**/
/*************************************************************************/
/*                                                                       */
/* 04.04.04 V001 Volker Pritsching  first code     !!! update please !!! */
/*                                                                       */
/*************************************************************************/

/*************************************************************************/
/*
         1.1. Imports                                                               
*/
/*************************************************************************/
#include <stdio.h>
#include <string.h>
#include <avr/io.h>

#include <avr/eeprom.h>
#include <avr/sleep.h>

#include "ATMEGA_RC5.h"
#include "ATMEGA_KEY.h"
#include "ATMEGA_LCD.h"
#include "ATMEGA_CLK.h"

#include "SystemGlobals.h"
#include "SystemCore.h"
#include "Simulator_TSFW.h"

#undef DEBUG
/*************************************************************************/
/*
        1.2 Globals                                                               
*/
enum {Idle,Run,Setup,SetEx,SetPause,SetReload,Exposure,Pause,Wait,SetContrast,SetBrightness};
/*************************************************************************/
#define MASTERCLOCK 50 //Taktfrequenz in Hz des Hautptacktes

#define Set_SLR1 PORTB|=0x02
#define Reset_SLR1 PORTB&=~0x02
#define Set_SLR2 PORTB|=0x04
#define Reset_SLR2 PORTB&=~0x04

#define keyB 0x38 //Key brightness 
#define keyC 0x11 //Key constast
#define keyM 0x21 //Key Mode 
#define keyU 0x0a //Key Up 

/*************************************************************************/
/*
         1.2.1 Prototypes of Functions
*/
/*-----------------------------------------------------------------------*/
/* Prototypes of Functions for Command Interpreter: Commands and Queries */
/*-----------------------------------------------------------------------*/
void fSetIdle (void);
void fSerialSendChar(unsigned char CHAR);

static unsigned short fTimerPause (char *tParm);
static unsigned short fTimerExposure (char *tParm);
static unsigned short fTimerCycle (char *tParm);
static unsigned short fRST_LCD (char *tParm);
static unsigned short fWriteLine (char *tParm);
static unsigned short fReadLine (char *tParm);

char ucLine[17];
//unsigned int uiPreSimulator =0;

/*-----------------------------------------------------------------------*/
/*  Functions (aktualisieren, weitere Funktionen hinzufuegen)    */
/*-----------------------------------------------------------------------*/
COM_DEF asSimulator_ComDef [] =
{
   {":FT?",                 fTimerExposure},
   {":FP?",                 fTimerPause},
   {":FC?",                 fTimerCycle},
   {":RST",                 fRST_LCD},
   {":WL",                  fWriteLine},
   {":RD?",                 fReadLine},
   
   { NULL,                  NULL}                // array must end with NULL
};
static unsigned int eePauseTime EEMEM;
static unsigned int eeExposureTime EEMEM;
static unsigned int eeReload EEMEM;
static int iRAM_EX;
static int iRAM_PS;
static int iRAM_RL;
//static int iSec,iSleep;
static unsigned int eeContrast EEMEM;
static unsigned int eeBrightness EEMEM;
static int iRAM_Contrast;
static int iRAM_Brightness;
//static char ucTimeflag;
static unsigned char ucIndex = 0;


unsigned char ucState = Idle;
/*************************************************************************/
/*
         TSFW Interface Calls
*/
/*************************************************************************/
void fSimulator_Init(void){
#ifdef DEBUG
 fSerialSendStr("fSimulator_Init(void)");
#endif

  if ((iRAM_EX = eeprom_read_word(&eeExposureTime)) < 0) iRAM_EX= 11;
  if ((iRAM_PS = eeprom_read_word(&eePauseTime)) < 0) iRAM_PS = 22;
  if ((iRAM_RL = eeprom_read_word(&eeReload)) < 0) iRAM_RL = 33;
  if ((iRAM_Brightness = eeprom_read_word(&eeBrightness)) < 0) iRAM_Brightness = 100;
  if ((iRAM_Contrast   = eeprom_read_word(&eeContrast)) < 0) iRAM_Contrast = 100;
  fSetIdle();

}
/*************************************************************************/
/*
         2.0 Locals    
*/
/*************************************************************************/
void fSetIdle(void){
  fDisplay(1,"   Simulator    ");
  fDisplay(4,"Set Run Hel Con ");
  Reset_SLR1;
  Reset_SLR2;
}
/*************************************************************************/
/*                                                                       */
/* 
         3.4 Functions   : Timer             
*/
/*                                                                       */
/* Description:                            */
/*                                                                       */
/* Return     :                                */
/*                                                                       */
/*                                                                       */
/*************************************************************************/
static unsigned short fTimerPause (char *pcParm){
int iValue;

  if((sscanf (pcParm, "%i", &iValue)) == 1) {
    eeprom_write_word(&eePauseTime, (unsigned int)iValue); // schreiben
     tMSG_Buffer[0] = 'H';
     tMSG_Buffer[1] = 0;
     RETURN( NO_ERR, tMSG_Buffer);
     }
  iValue = (int) eeprom_read_word(&eePauseTime);
  sprintf (tMSG_Buffer,"Value: %i",iValue);
  RETURN( NO_ERR, tMSG_Buffer);
}
/*************************************************************************/
static unsigned short fTimerExposure (char *pcParm){
int iValue;

  if((sscanf (pcParm, "%i", &iValue)) == 1) {
     eeprom_write_word(&eeExposureTime, (unsigned char)iValue); // schreiben
     tMSG_Buffer[0] = 'H';
     tMSG_Buffer[1] = 0;
     RETURN( NO_ERR, tMSG_Buffer);
     }
  iValue = (int) eeprom_read_word(&eeExposureTime);
  sprintf (tMSG_Buffer,"Value: %i",iValue);
  RETURN( NO_ERR, tMSG_Buffer);
}
/*************************************************************************/
fSend(unsigned char ucZ, unsigned char ucP, char *cS ){
int i;

fSerialSendChar(0xfe);
fSerialSendChar(0x00);
if(ucZ ==1) ucP |= 0xC0;
fSerialSendChar(ucP);
ucP = strlen(cS);
fSerialSendChar(ucP);
for (i=0;i<ucP;i++) fSerialSendChar(cS[i]);


}

static unsigned short fWriteLine (char *pcParm){
int i, iZ,iP;
unsigned char ucP;
char cS[17];

sscanf (pcParm, "%i %i %s", &iZ,&iP,cS);
fSerialSendChar(0xfe);
fSerialSendChar(0x00);
if(iZ ==0) ucP = (unsigned char) iP;
if(iZ ==1) ucP = 0xC0 + (unsigned char) iP;
fSerialSendChar(ucP);
ucP = strlen(cS);
fSerialSendChar(ucP);
for (i=0;i<ucP;i++) fSerialSendChar(cS[i]);

RETURN( NO_ERR, NULL);
}
/*************************************************************************/
static unsigned short fReadLine (char *pcParm){
int iValue;

  if((sscanf (pcParm, "%i", &iValue)) == 1) {
     eeprom_write_word(&eeExposureTime, (unsigned char)iValue); // schreiben
     tMSG_Buffer[0] = 'H';
     tMSG_Buffer[1] = 0;
     RETURN( NO_ERR, tMSG_Buffer);
     }
  iValue = (int) eeprom_read_word(&eeExposureTime);
  sprintf (tMSG_Buffer,"Value: %i",iValue);
  RETURN( NO_ERR, tMSG_Buffer);
}/*************************************************************************/
static unsigned short fRST_LCD (char *pcParm){
int iValue;

  *pcParm =NULL;
  fSerialSendChar(0xfe);
  RETURN( NO_ERR, NULL);
}
/*************************************************************************/
static unsigned short fTimerCycle (char *pcParm){
int iValue;
  if((sscanf (pcParm, "%i", &iValue)) == 1) {
    eeprom_write_word(&eeReload, (unsigned char)iValue); // schreiben
     tMSG_Buffer[0] = 'H';
     tMSG_Buffer[1] = 0;
     RETURN( NO_ERR, tMSG_Buffer);
     }
  iValue = (int) eeprom_read_word(&eeReload);
  sprintf (tMSG_Buffer,"Value: %i",iValue);
  RETURN( NO_ERR, tMSG_Buffer);
}


unsigned int fSetNumber(unsigned int uiValue){

switch(ucIndex){
 case 0:
   uiValue++;
   break;
 case 1:
   uiValue +=10;
   break;
 case 2:
   uiValue +=100;
   break;
 case 3:
   uiValue +=1000;
   break;
 default:
   break;
  }

return (uiValue);
}

/*************************************************************************/
unsigned char fStatemaschine (unsigned char ucState,unsigned char ucCode){
unsigned char ucT;
unsigned int uiT;
static unsigned int ucWaitState;
switch (ucState) {
/*************************************************************************/
  case Idle:
    if ((iRAM_EX = eeprom_read_word(&eeExposureTime))<0)       iRAM_EX =20;
    if ((iRAM_PS = eeprom_read_word(&eePauseTime)) <0)         iRAM_PS = 10;
    if ((iRAM_RL = eeprom_read_word(&eeReload)) <0)            iRAM_RL = 30;
    if ((iRAM_Brightness = eeprom_read_word(&eeBrightness)) <0)iRAM_Brightness =100;
    if ((iRAM_Contrast   = eeprom_read_word(&eeContrast)) <0)   iRAM_Contrast = 100;
    switch (ucCode){
     case keyM:
	   sprintf(ucLine,"S_Exposure: %04d",iRAM_EX);
       fDisplay(1,ucLine);
       fDisplay(4,"Sav Nxt  D+  V+ ");
	   ucIndex =0;
       fDisplay((0x5F-ucIndex),ucLine);
       ucState = SetEx;
	   break;
     case keyU:
//       if ((iRAM_RL <= 0) || (iRAM_PS <= 0) || (iRAM_EX <= 0)) fSetIdle();
//       else {
	     sprintf(tMSG_Buffer,"Exposure:   %04d",iRAM_EX);
	  	 fDisplay(1,tMSG_Buffer);
         fDisplay(4,"Stp Pse  Bns Con");
//	     sprintf(tMSG_Buffer,"PS:%04d RL:%04d ",iRAM_PS,iRAM_RL);
//	 	 fDisplay(2,tMSG_Buffer);
	     ucState = Exposure;
//		 }
	   break; 
     case keyB: 
       ucT = eeprom_read_word(&eeBrightness);
       if (iRAM_Brightness != ucT ) eeprom_write_word(&eeBrightness, iRAM_Brightness);
       if ((OCR1A+=50) > 900) OCR1A = 100;;
	   break; 
     case keyC:
       ucT = eeprom_read_word(&eeContrast);
       if (iRAM_Contrast != ucT ) eeprom_write_word(&eeContrast, iRAM_Contrast);
       if ((OCR1B+=50) > 700) OCR1B = 100;      
	   break;
     default:
       break;
	   }
	break;
/*************************************************************************/
  case SetEx:
    switch (ucCode){
     case keyM:
	   iRAM_EX = 1000*(ucLine[12]-0x30) + 100*(ucLine[13]-0x30) + 10*(ucLine[14]-0x30) +(ucLine[15]-0x30) ;
       uiT = eeprom_read_word(&eeExposureTime);
       if (iRAM_EX != uiT ) eeprom_write_word(&eeExposureTime, iRAM_EX);
     case keyU:
       ucIndex =0;  
       sprintf(ucLine,"S_Pause:    %04d",iRAM_PS);
       fDisplay(1,ucLine);
       fDisplay(4,"Sav Nxt  D+  V+ ");
       fDisplay((0x5F-ucIndex),ucLine);
       ucState = SetPause;
	   break; 
     case keyB:
	   ucIndex= ++ucIndex %4;
       fDisplay((0x5F-ucIndex),ucLine);
	   break; 
     case keyC: 
       if (++ucLine[15-ucIndex] > 0x39 ) ucLine[15-ucIndex] = 0x30;	   
       fDisplay(1,ucLine);
       fDisplay((0x5F-ucIndex),ucLine);
       break;
     default:
       break;
	   }
    break;
/*************************************************************************/
  case SetPause:
    switch (ucCode){
     case keyM:
	   iRAM_PS = 1000*(ucLine[12]-0x30) + 100*(ucLine[13]-0x30) + 10*(ucLine[14]-0x30) +(ucLine[15]-0x30) ;
       uiT = eeprom_read_word(&eePauseTime);
       if (iRAM_PS != uiT ) eeprom_write_word(&eePauseTime, iRAM_PS);
     case keyU:
	   ucIndex =0;
       sprintf(ucLine,"S_Reload:   %04d",iRAM_RL);
       fDisplay(1,ucLine);
       fDisplay(4,"Sav Nxt  D+  V+ ");
       fDisplay((0x5F-ucIndex),ucLine);
       ucState = SetReload;
	   break; 
     case keyB:
	   ucIndex= ++ucIndex %4;
       fDisplay((0x5F-ucIndex),ucLine);
	   break; 
     case keyC: 
       if (++ucLine[15-ucIndex] > 0x39 ) ucLine[15-ucIndex] = 0x30;	   
       fDisplay(1,ucLine);
       fDisplay((0x5F-ucIndex),ucLine);
       break;
     default:
       break;
	   }
    break;
/*************************************************************************/
  case SetReload:
    switch (ucCode){
     case keyM:
	   iRAM_RL = 1000*(ucLine[12]-0x30) + 100*(ucLine[13]-0x30) + 10*(ucLine[14]-0x30) +(ucLine[15]-0x30) ;
       uiT = eeprom_read_word(&eeReload);
       if (iRAM_RL != uiT ) eeprom_write_word(&eeReload, iRAM_RL);
     case keyU:
       fSetIdle();
       ucState = Idle;
 	   break; 
     case keyB:
	   ucIndex= ++ucIndex %4;
       fDisplay((0x5F-ucIndex),ucLine);
	   break; 
     case keyC: 
       if (++ucLine[15-ucIndex] > 0x39 ) ucLine[15-ucIndex] = 0x30;	   
       fDisplay(1,ucLine);
       fDisplay((0x5F-ucIndex),ucLine);
       break;
     default:
       break;
	   }
   break;
/*************************************************************************/
  case Exposure:
    switch (ucCode){
     case keyM:
       fSetIdle();  
       ucState = Idle;
	   break;
    case keyU:
	   ucWaitState = Exposure; ucState = Wait;
       fDisplay(4,"Stp Con  Bns Con");
 	   break; 
     case keyB: 
       ucT = eeprom_read_word(&eeBrightness);
       if (iRAM_Brightness != ucT ) eeprom_write_word(&eeBrightness, iRAM_Brightness);
	   break; 
     case keyC:
       ucT = eeprom_read_word(&eeContrast);
       if (iRAM_Contrast != ucT ) eeprom_write_word(&eeContrast, iRAM_Contrast);
       break;
     default:
       if (ucClockUpdate) {
         ucClockUpdate =0;
         if (--iRAM_EX >= 0){
           sprintf (tMSG_Buffer,"Exp:  %04d   %03d",iRAM_EX,iRAM_RL);
           fDisplay(1,tMSG_Buffer);
	       Set_SLR1;
	       Set_SLR2;
		   }
	     else {
	       iRAM_EX = eeprom_read_word(&eeExposureTime);
	       if (iRAM_RL >=1){	  
              sprintf (tMSG_Buffer,"Pause %04d   %03d",iRAM_PS,iRAM_RL);
	          fDisplay(1,tMSG_Buffer);
//	          sprintf(tMSG_Buffer,"RL:%04d  EX:%04d",iRAM_RL,iRAM_EX);
//	          fDisplay(2,tMSG_Buffer);
	          ucState = Pause;
		      }
           else {
		     fSetIdle();
			 ucState = Idle;
             }
		  }
	    }
	  }
    break;

/*************************************************************************/
  case Pause:
    switch (ucCode){
     case keyM:
       fSetIdle();
       ucState = Idle;
     case keyU:
	   ucWaitState = Pause; ucState = Wait;
       fDisplay(4,"Stp Pse  Bns Con");
 	   break; 
     case keyB: 
       ucT = eeprom_read_word(&eeBrightness);
       if (iRAM_Brightness != ucT ) eeprom_write_word(&eeBrightness, iRAM_Brightness);
	   break; 
     case keyC:
       ucT = eeprom_read_word(&eeContrast);
       if (iRAM_Contrast != ucT ) eeprom_write_word(&eeContrast, iRAM_Contrast);
       break;
     default:
       if (ucClockUpdate) {
         ucClockUpdate =0;
         if (--iRAM_PS >= 0){
              sprintf (tMSG_Buffer,"Pause %04d   %03d",iRAM_PS,iRAM_RL);
	       fDisplay(1,tMSG_Buffer);
	       Reset_SLR1; Reset_SLR2;
	  	   }
	     else {
 	       iRAM_PS = eeprom_read_word(&eePauseTime);	  
           sprintf (tMSG_Buffer,"Exp:  %04d   %03d",iRAM_EX,iRAM_RL);
	       fDisplay(1,tMSG_Buffer);
		   iRAM_RL--;
	       ucState = Exposure;
		  }
	    }
	  }
    break;
/*************************************************************************/
  case Wait:
   fDisplay(1,"            Wait");
   if (ucCode ==  keyM){
     fSetIdle(); 
     ucState = Idle;
	 }
   if (ucCode == keyU) {
	    Reset_SLR1;
		Reset_SLR2;
		ucState = ucWaitState;
        fDisplay(4,"Stp Pse  Bns Con");
     }
   break;
  default: 
    break;
  }

return(ucState);
}

/*************************************************************************/
void fSerialSendChar(unsigned char CHAR){
#ifdef DEBUG
   sprintf(tMSG_Buffer,"KeyCode 0x%X ",CHAR); fSerialSendStr(tMSG_Buffer);
#else
   fSerial_putchar(CHAR);
#endif
}

void sCycleSimulator(void) {    // wird in der Rubberbendig Loop aufgerufen 

//static unsigned char ucNumberState = hunderter;
static unsigned char ucStateMashine = Idle;
static unsigned char ucToggle = 0;
unsigned char ucCode=0;

#ifdef DEBUG
// fSerialSendStr("sCycleSimulator()");
#endif

// Keypad einlesen und auswerten
if (sKey.cStatus >=0){
   if ( sKey.ucCode == 0x11) fSerialSendChar(0xfd);
   if ( sKey.ucCode == 0x21) fSend(0, 1, "Hanbox Checked");    
   if ( sKey.ucCode == 0x0a){fSend(1, 1, "V-Move500,0");    
//                             fSend(2, 1, "V Focus 0,3");    
                            }
   sprintf(tMSG_Buffer,"Key: %02x:%02x S=%x   ", sKey.ucAddr,sKey.ucCode,sKey.cStatus);
   fDisplay(3,tMSG_Buffer);
#ifdef DEBUG
  fSerialSendStr(tMSG_Buffer);
#endif
  if (ucToggle == sKey.cStatus) sKey.cStatus = -1;
  else {
    ucToggle = sKey.cStatus;
    ucCode = sKey.ucCode;
    sKey.cStatus = -1;
    }
#ifdef DEBUG
   sprintf(tMSG_Buffer,"Key: %02x:%02x  S=%x   ", sKey.ucAddr,sKey.ucCode,sKey.cStatus);
#endif
  } 
  ucStateMashine = fStatemaschine(ucStateMashine,ucCode);
/*
iSec=iSec+1;

 if (iSec == 2000){ // second is over
   iSec =0;
//   PORTD  ^=  0x40; // test toggle for timer
   ucTimeflag++;
   if (++iSleep == 600) {
   fDisplay(1,"Good Night      ");
   fDisplay(2,"I go to bed now ");
   PORTC &= ~0x08;                                 // setze scannoutput aktive for INT 0
   GICR |= 0x40;                                   // Enable INTo for wake UP
                          // disable PWM for Contrast
   SREG |= 0x80;
   set_sleep_mode(SLEEP_MODE_PWR_DOWN);
   sleep_mode();
   }
  }*/
 
}


