/*************************************************************************/
/*                                                                       */
/* Name       : LCD.c             Version in project: 001                */
/*                                              // !!! update please !!! */
/* Author     : Volker Pritsching                                        */
/*                                                                       */
/* Language   : C                                                        */
/*                                                                       */
/* Description: CAN_at_Home version: 001 vpr                             */
/*              Treiber f r eine LCD Anzeige   4 Bit version             */
/*                                                                       */
/*************************************************************************/
/*                                                                       */
/* 14.11.03 001 Volker Pritsching  first code      !!! update please !!! */
/* 14.8.05  002 Returnvalue init added                                   */
/* 4.10.2005 003 Portiert to Atmel ATMega8515                            */
/*************************************************************************/
/* Imports                                                                */

#define DataPort PORTA
#define AZEN PA1
#define AZRS PA3
#define AZRW PA2
#define bIn  PA7
#define PWM_CONTRAST PD3
#define PWM_Background PD4
/*************************************************************************/
#include <inttypes.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/sleep.h>

#include "SystemGlobals.h"

unsigned char fDisplay (unsigned char ucZeile, char* disp_buffer);
void fSerialSendStr ( char* disp_buffer);

/*************************************************************************/
/* Exports                                                               */
/*************************************************************************/
unsigned char ucLCD_available;           /* Gobal Hardwareflag           */
unsigned char fDisplay(unsigned char ucLine, char* disp_buffer);
/*************************************************************************/
/* Locals                                                                */
/*************************************************************************/
unsigned char busy();
unsigned char fLCD_init ();
/*************************************************************************/
/*                                                                       */
/* Function   : fLCDinit                                                 */
/*                                                                       */
/* Description: Init-Function for Display function                       */
/*                                                                       */
/* Return     : display available                                        */
/*                                                                       */
/*************************************************************************/
unsigned char fLCDInit(void)
{
if ((ucLCD_available = fLCD_init()) == NO_ERR);{ 

#ifdef DEBUG
fSerialSendStr("fLCDInit (aviailable)");
#endif
  fDisplay(1," AVR Steuerung  ");
  fDisplay(2,"V.P. @2004/2007 ");
//  OCR1A = 200;
//  OCR1B = 200;      
  }
return(ucLCD_available);
}
/*************************************************************************/
/* Copyright: 			Volker Pritsching                                */
/* Datum Ersterstellung:23.11.2001                                       */
/* Zielhardware: 		uP Fujitsu 90xxx                                 */
/* Headerfile: 			lcd.h                                            */
/* Parameter:           Ausagbeport und Bits                             */
/*************************************************************************/
/*       anzeige_init: initialize anzeige interface                      */
/*************************************************************************/
/*************************************************************************/
/* local Subroutine wait until LCD ready                                 */
/* after 250 tries return with error            azd7 P2.6                */
/*************************************************************************/
unsigned char busy()
{
unsigned short usCounter = 25000;
unsigned char  ucBusy = 0x80;
DDRA &= ~(1<<PA7) ;    /* PA7 Busybit  als Eingaenge */
  do{

  PORTA &= ~((1<<AZEN)|(1<<AZRS));          //  AZEN = 0; AZRS = 0;
  PORTA |=  (1 <<AZRW);                     //  AZRW = 1;
  PORTA |=  (1<<AZEN);                      //  AZEN = 1;
//  PORTC |=  (1<<AZEN);                      //  AZEN = 1;
  ucBusy = PINA;                            //    bIn = AZD7;
  PORTA &= ~(1<<AZEN);                      //  AZEN = 0;
    usCounter --;
  }while(((ucBusy & 0x80) ==0x80 ) && (usCounter != 0));
  DDRA |= (1<<PA7) ;    /* PA7 Busybit  als Ausgang */
  if (usCounter == 0) return(HWMISSING_ERR);
return(NO_ERR);
}
/*************************************************************************/
/* local Subroutine write Command                                        */
/* if LCD not ready return with error                                    */
/*************************************************************************/
unsigned char write_CMD (unsigned char cmd){
  unsigned char ucStatus;
  if ((ucStatus  = busy()) == HWMISSING_ERR) return (HWMISSING_ERR);
  PORTA &= ~((1<<AZEN)|(1<<AZRS)|(1<<AZRW));//  AZEN = 0; AZRS = 0; AZRW = 0;
  PORTA  =   cmd & 0xF0;
  PORTA |=  (1<<AZEN);                      //  AZEN = 1;
  PORTA &= ~(1<<AZEN);                      //  AZEN = 0;
  PORTA  =   (cmd << 4) & 0xf0;
  PORTA |=  (1<<AZEN);                      //  AZEN = 1;
  PORTA &= ~(1<<AZEN);                      //  AZEN = 0;
  return(NO_ERR);
  } 
/*************************************************************************/
/* local Subroutine write Data                                           */
/* if LCD not ready return with error                                    */
/*************************************************************************/
unsigned char write_Data (unsigned char dat){
 unsigned char ucStatus;
  if ((ucStatus = busy()) == HWMISSING_ERR) return (HWMISSING_ERR);
  PORTC &= ~((1<<AZEN)|(1<<AZRW));          //  AZEN = 0;AZRW = 0;
  PORTC |=  ((1<<AZRS));                    //  AZRS = 1;
  PORTA  =   (dat & 0xF0) | (1<<AZRS);
  PORTA |=  (1<<AZEN);                      //  AZEN = 1;
  PORTA &= ~(1<<AZEN);                      //  AZEN = 0;
  PORTA  =   ((dat <<4) & 0xF0) | (1<<AZRS);
  PORTA |=  (1<<AZEN);                      //  AZEN = 1;
  PORTA &= ~(1<<AZEN);                      //  AZEN = 0;
  return (NO_ERR);} 
/*************************************************************************/
/* Public Subroutine INIT der Anzeige                                    */
/* if LCD not ready return with error                                    */
/*************************************************************************/
unsigned char fLCD_init ()
{
unsigned short usCounter; 
unsigned char ucStatus; 
// wait 30ms after power up
  for(usCounter=0; usCounter <= 6000; usCounter++);
  PORTA =  0x30;                            //  
  PORTA |=  (1<<AZEN);                      //  AZEN = 1;
  PORTA |=  (1<<AZEN);                      //  AZEN = 1;
  PORTA &= ~(1<<AZEN);                      //  AZEN = 0;
// wait 40 us  
  for(usCounter=0; usCounter <= 5000; usCounter++);
  PORTA =  0x30;                            //  
  PORTA |=  (1<<AZEN);                      //  AZEN = 1;
  PORTA |=  (1<<AZEN);                      //  AZEN = 1;
  PORTA &= ~(1<<AZEN);                      //  AZEN = 0;
  for(usCounter=0; usCounter <= 5000; usCounter++);
  PORTA =  0x30;                            //  
  PORTA |=  (1<<AZEN);                      //  AZEN = 1;
  PORTA |=  (1<<AZEN);                      //  AZEN = 1;
  PORTA &= ~(1<<AZEN);                      //  AZEN = 0;
  for(usCounter=0; usCounter <= 5000; usCounter++);
  PORTA =  0x20;                            //  
  PORTA |=  (1<<AZEN);                      //  AZEN = 1;
  PORTA |=  (1<<AZEN);                      //  AZEN = 1;
  PORTA &= ~(1<<AZEN);                      //  AZEN = 0;
  for(usCounter=0; usCounter <= 5000; usCounter++);
  if ((ucLCD_available = busy ()) == HWMISSING_ERR ) return HWMISSING_ERR;
  if ((ucStatus = write_CMD(0x0E)) == HWMISSING_ERR) return HWMISSING_ERR;
  if ((ucStatus = write_CMD(0x06)) == HWMISSING_ERR) return HWMISSING_ERR;
  return NO_ERR;
}
/*************************************************************************/
/* Public Subroutine fDisplay                                            */
/* Ausgabe einer Zeichenkette im displaybuffer                           */
/*************************************************************************/
unsigned char fDisplay (unsigned char ucZeile, char* disp_buffer){
unsigned char usCounter;
//unsigned char ucStatus; 
  if (ucLCD_available == HWMISSING_ERR) return(HWMISSING_ERR);
  if (ucZeile==1) write_CMD (0x80);                // Schreibpos Anfang Zeile 1
  if (ucZeile==2) write_CMD (0xC0);                // Schreibpos Anfang Zeile 2
  if (ucZeile==3) write_CMD (0x90);                // Schreibpos Anfang Zeile 3
  if (ucZeile==4) write_CMD (0xD0);                // Schreibpos Anfang Zeile 4
  if ((ucZeile & 0xf0)>0x50) write_CMD (ucZeile);  // if Groesser 50 direkt mode
  if ((ucZeile & 0xf0)==0x50) {                    // setzen cursor on/off
      write_CMD (0x80+(ucZeile & 0x0f));
      write_CMD (0x0f);
	  return(NO_ERR);}
usCounter=0;
while(disp_buffer[usCounter] != 0) 
   write_Data (disp_buffer[usCounter++]);
return(NO_ERR);
}
