/****************************************************************************************/
/*                                                                                      */
/* Name       : T_SYST.H              Version in project: 001  // !!! update please !!! */
/*                                                                                      */
/* Author     : Gerhard Ort                                                             */
/*                                                                                      */
/* Language   : C                                                                       */
/*                                                                                      */
/* Description: Template version: 001.020215go                                          */
/*              System Include File                                                     */
/*              takes global Definitions and System Resource Information                */
/*                                                                                      */
/****************************************************************************************/
/*                                                                                      */
/* 12.05.99 V001 Gerhard Ort File created                      // !!! update please !!! */
/*                                                                                      */
/****************************************************************************************/


/*--------------------------------------------------------------------------------------*/
/* include control                                                                      */
/*--------------------------------------------------------------------------------------*/
#ifndef __INC_Systemglobals
#define __INC_Systemglobals


/****************************************************************************************/
/* Imports                                                                              */
/****************************************************************************************/


/****************************************************************************************/
/* Exports                                                                              */
/****************************************************************************************/

#ifdef TSFW_SYS_SOURCE
#define T_EXTERN(vardef,init) vardef = init
#else
#define T_EXTERN(vardef,init) extern vardef
#endif

/*--------------------------------------------------------------------------------------*/
/*  System definition                                                                   */
/*--------------------------------------------------------------------------------------*/
// Target controller board 
//#define     T_MCB3
#define     T_CANOpen_SLIO

// memory pointer specifier for RAM accessing makros, like pucXRAM
#define     T_MEMPOINTER_KIND   

// CPU frequency in MHz
#ifndef FCLK
#define     FCLK    4
#endif
// constant variable for modules in Library
T_EXTERN( const unsigned char ucFCLK, FCLK );

// DEBUG-Mode, if no ASSERT-Messages should be used
#define     DEBUG
//#undef DEBUG
#ifdef DEBUG
T_EXTERN( const unsigned char ucDEBUG, 1 );
#else
T_EXTERN( const unsigned char ucDEBUG, 0 );
#endif

// Max. Bytes in one receive or send line
#define     COM_STRLEN_MAX  80
T_EXTERN( const unsigned char ucCOM_STRLEN_MAX, COM_STRLEN_MAX );

// Communication Interface to start with
T_EXTERN( const char *pcTSFW_DEFAULT_COMMUNICATION_COMMAND, "*RS232" );

// Testsoftware Command error output mode, to start with
// 1: the errors of commands or queries are output at once, no error mode
// 0: the errors of commands or queries take to an error mode, the error message has
//    to be read and reset with :syst:err?
T_EXTERN( unsigned char ucTSFW_DEBUG_START_MODE, 1 );

// max. of '0' parameters, which should be replaced by "00"
#define MAX_0_00_REPLACE   10
T_EXTERN( const unsigned char ucMAX_0_00_REPLACE, MAX_0_00_REPLACE );

// Tputchar output mode to start with
// 1: all asynchronous messages are output at once, 0: messages are output after query
T_EXTERN( unsigned char ucTPUTCHAR_CLEARING_START_MODE, 0 );

// Watchdog-Trigger - define it here, if needed
#ifndef TRIGGER_WATCHDOG
#define TRIGGER_WATCHDOG
#endif

/*--------------------------------------------------------------------------------------*/
/* TSFW - ERROR Numbers                                                                 */
/*--------------------------------------------------------------------------------------*/
#define         NO_ERR          0
#define         COM_ERR         1
#define         MEM_ERR         2
#define         HWMISSING_ERR   3
#define         SYNTAX_ERR      4
#define         PARM_ERR        5
#define         RTX_ERR         6
#define         QUERY_ERR       7
#define         COMMAND_ERR     8
#define         ASSERT_ERR      9
#define         COM_NOT_FINISHED 10

/*--------------------------------------------------------------------------------------*/
/* Registerbanks used (only information)                                                */
/*--------------------------------------------------------------------------------------*/
// ?C_MAINREGISTERS: Registerbank for main function

/*--------------------------------------------------------------------------------------*/
/* used system resources                                                                */
/* Interrupt-Sources with Interrupt Priority Level (ILVL) and Group-Level (GLVL)        */
/*--------------------------------------------------------------------------------------*/
// Timer3, Trap Number 0x23, ILVL=8, GLVL=0  defined in t_moduls\mcb_tsfw.c

// Serial-Transmit, 0x2a, ILVL=4, GLVL=1  defined in t_comms/tci_232.c
// Serial-Receive, 0x2b, ILVL=4, GLVL=2  defined in t_comms/tci_232.c


#endif
