/*************************************************************************/
/*
Inhalt
         1.0  : SAM2_tsfw.c
         1.1. Imports                                                               
         1.2 Globals  
         1.2.1 Prototypes of Functions
         2.0 Locals    
         3.  Modul Routinen ControlControl    
         3.1 Function    : Init       
         3.2 Function    : f              
         3.4 Functions   : Timer             
         3.5 Function    : fSetGet_System                 
         4.1 ISR Routine : ISR_FotoTimerTask()     
         5.0 Task        : sCycleFotoTimer()                                                  
*/
/*************************************************************************/
/*                                                                       */
/* Name     
         1.0  : TeleskopControl.c             Version in project: 001     */
/*                                              // !!! update please !!! */
/* Author     : Volker Pritsching                                        */
/*                                                                       */
/* Language   : C                                                        */
/*                                                                       */
/* Description: Kleinsteuerung f r Telekope version: VX00A vpr           */
/*              Bitte hier eine Beschreibung eintragen                   */
/*                                                                       */
/**/
/*************************************************************************/
/*                                                                       */
/* 04.04.04 V001 Volker Pritsching  first code     !!! update please !!! */
/*                                                                       */
/*************************************************************************/

/*************************************************************************/
/*
         1.1. Imports                                                               
*/
/*************************************************************************/
#include <stdio.h>
#include <string.h>
#include <avr/io.h>

#include <avr/eeprom.h>
#include <avr/sleep.h>

#include "ATMEGA_RC5.h"
#include "ATMEGA_KEY.h"
#include "ATMEGA_LCD.h"
#include "ATMEGA_CLK.h"

#include "SystemGlobals.h"
#include "SystemCore.h"
#include "SAM2_tsfw.h"

#undef DEBUG
#define DEBUG 
/*************************************************************************/
/*
        1.2 Globals                                                               
*/
//enum {Idle,Run,Setup,SetEx,SetPause,SetReload,Exposure,Pause,Wait,SetContrast,SetBrightness};
/*************************************************************************/
#define MASTERCLOCK 50 //Taktfrequenz in Hz des Hautptacktes


unsigned char ucStatusISR;       // StatusFlag , x, x, x, TS, MS2, MS1, MS0
unsigned int uiCounterSAM2;
extern unsigned long int ulTime;
/*************************************************************************/
/*
        1.2 Modul Global                                                               
*/

tTimeDate tNow;

char cChannelIndex;
double fTemperature;
static unsigned int uiMagSensor[3];
static char ucDeviceID[8];
static char cScratch[9];

void fDisplay(char, char *Buffer);
void fSerialSendStr( char *Buffer);
/*************************************************************************/
/*
         1.2.1 Prototypes of Functions
*/
/*-----------------------------------------------------------------------*/
/* Prototypes of Functions for Command Interpreter: Commands and Queries */
/*-----------------------------------------------------------------------*/

static unsigned short fTemperatureRead (char *tParm);
static unsigned short fMagnetSensorRead(char *tParm);
static unsigned short fUTimeWriteRead (char *tParm);
static unsigned short fSAM2RecordRead (char *tParm);
static unsigned short fTestWrite (char *tParm);
static unsigned short fTestRead (char *tParm);
static unsigned short fIDRead (char *tParm);
static unsigned short fStatusRead (char *tParm);
static unsigned short fMemoryRead (char *pcParm);
/*-----------------------------------------------------------------------*/
/*  Functions (aktualisieren, weitere Funktionen hinzufuegen)    */
/*-----------------------------------------------------------------------*/
COM_DEF asSAM2_ComDef [] =
{
   {":TEMP:READ?",                 fTemperatureRead},
   {":MAGS:READ?",                 fMagnetSensorRead},
   {":SRR?",                       fSAM2RecordRead},
   {":UTIME?",                     fUTimeWriteRead},
   {":TEMP:READ?",                 fTestRead},
   {":TEMP:ID:READ?",              fIDRead},
   {":TEMP:MEMORY:READ?",          fMemoryRead},
   {":WRITE",                      fTestWrite},
   
   { NULL,                  NULL}                // array must end with NULL
};

/*************************************************************************/
/*
         TSFW Interface Calls
*/
/*************************************************************************/
void fSAM2_Init(void){
unsigned char ucSreg;
#ifdef DEBUG
 fSerialSendStr("fSAM2_Init(void)");
#endif

// Def Timer as Counter 
DDRB  = 0xED;  // pB1 is Input
ucSreg = SREG;
//_CLI();
TCCR1A = 0; 
TCCR1B = 0;    //Disable Source clock
TCNT1  = 0;    //clear Counterregister
//SREG = ucSreg;

tNow.sec   =0;
tNow.min   =59;
tNow.hour  =11;
tNow.day   =1;
tNow.month =9;
tNow.year  =7;
cChannelIndex = 0;
fTemperature =0.0;
uiMagSensor[0] =8000;
uiMagSensor[1] =16000;
uiMagSensor[2] =24000;
PORTB &= ~0x0D;                    // set Channelselect =0 
DDRD |= 0xC0;
fDisplay(2,"Init SAM2       ");
}
/*************************************************************************/
/*
         2.0 Modul Locals Variable    
*/
/*************************************************************************/
unsigned char OW_Reset(void);
void OW_Delay(unsigned int);
unsigned char OW_ReadDeviceAddress( char *Buffer);
int OW_GetTemperature(void);
/*************************************************************************/
/*                                                                       */
/* 
         3.4 Functions   : SAM2            
*/
/*                                                                       */
/* Description:                            */
/*                                                                       */
/* Return     :                                */
/*                                                                       */
/*                                                                       */
/*************************************************************************/
static unsigned short fTemperatureRead (char *pcParm){
int i=0;
	 i= OW_GetTemperature();
	 if (i % 2) {
	 sprintf (tMSG_Buffer,"0x%02X 0x%02x Temp: %i.5 C",
                       cScratch[1],cScratch[0],i/2);
	 }
	 else {
	 sprintf (tMSG_Buffer,"0x%02X 0x%02x Temp: %i C",
                       cScratch[1],cScratch[0],i/2);
	 }
  RETURN( NO_ERR, tMSG_Buffer);
}
/*************************************************************************/
static unsigned short fMagnetSensorRead (char *pcParm){
int iValue;

  if((sscanf (pcParm, "%i", &iValue)) == 0) {
     sprintf (tMSG_Buffer,"M2=%u M1=%u M0=%u",uiMagSensor[2],uiMagSensor[1],uiMagSensor[0]);
     RETURN( NO_ERR, tMSG_Buffer);
     }
  else
     sprintf (tMSG_Buffer,"Magnetsensor %i: %i",iValue,uiMagSensor[iValue]);
  RETURN( NO_ERR, tMSG_Buffer);
}
/*************************************************************************/
static unsigned short fUTimeWriteRead (char *pcParm){
unsigned long ulT;
/*int iVs,iVm,iVh,iVD,iVM,iVY;
  if((sscanf (pcParm, "%i-%i-%i %i:%i:%i", &iVD, &iVM, &iVY, &iVh, &iVm, &iVs)) > 5) {
    tNow.sec   =0;
    tNow.min   =59;
    tNow.hour  =11;
    tNow.day   =1;
    tNow.month =9;
    tNow.year  =7;
    }
  sprintf (tMSG_Buffer,"UTime: %i-%i-20%i %i:%i:%i",iVD,iVM,iVY,iVh,iVm,iVs);
  */
  if((sscanf (pcParm, "%lu", &ulT)) ==1 ) ulTime = ulT;
  sprintf(tMSG_Buffer," Time %lu ",ulTime);
  RETURN( NO_ERR, tMSG_Buffer);
}
/*************************************************************************/
static unsigned short fSAM2RecordRead (char *pcParm){

/* dd-mm-yy;hh:mm.sec;temperature;sensor1;sensor2;sensor3 */


pcParm = NULL;

sprintf (tMSG_Buffer,"UTime: %i-%i-%i %i:%i:%i;%4.2f;%u;%u;%u",tNow.day,tNow.month,tNow.year,
                                                               tNow.hour,tNow.min,tNow.sec,
															   fTemperature,
															   uiMagSensor[2],uiMagSensor[1],uiMagSensor[0]);
  RETURN( NO_ERR, tMSG_Buffer);
}
/*************************************************************************/
static unsigned short fTestWrite (char *pcParm){
int iValue;
//((  if((sscanf (pcParm, "%i", &iValue)) == 1) {
  sscanf (pcParm, "%i", &iValue);
  sprintf (tMSG_Buffer,"TestValue: %i  ",iValue); fDisplay(1,tMSG_Buffer);
  DDRD |= 0x40;
  while(1){
    PORTD |= 0x40;
	OW_Delay((unsigned int) iValue);
    PORTD &= ~0x40;	}
  RETURN( NO_ERR, tMSG_Buffer);
}
/*************************************************************************/
static unsigned short fIDRead (char *pcParm){
  OW_ReadDeviceAddress(ucDeviceID);
  sprintf (tMSG_Buffer,"0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x",
                       ucDeviceID[7],ucDeviceID[6],ucDeviceID[5],ucDeviceID[4],
					   ucDeviceID[3],ucDeviceID[2],ucDeviceID[1],ucDeviceID[0]);

  
  RETURN( NO_ERR, tMSG_Buffer);
}
/*************************************************************************/
static unsigned short fMemoryRead (char *pcParm){
int i;

  if (OW_Reset() ==0){
     OW_WriteByte(0xCC);
     OW_WriteByte(0xBE);
     for (i=0;i<9;i++) cScratch[i] = OW_ReadByte();
	 sprintf (tMSG_Buffer,"0x%02x 0x%02x  0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x ",
                       cScratch[8],cScratch[7],cScratch[6],cScratch[5],cScratch[4],
					   cScratch[3],cScratch[2],cScratch[1],cScratch[0]);
	  }
  RETURN( NO_ERR, tMSG_Buffer);
}
/*************************************************************************/
static unsigned short fTestRead (char *pcParm){
int iValue;
  if (OW_Reset() ==0){
     OW_WriteByte(0xCC);
     OW_WriteByte(0xb4);
	 iValue = (int) OW_ReadByte();
	 }
  sprintf (tMSG_Buffer, "Powermode: %i",iValue);

  RETURN( NO_ERR, tMSG_Buffer);
}

/*************************************************************************/

void sCycleSAM2(void) {  // wird in der Rubberbendig Loop alle seckunde aufgerufen 
int iTemperatur;
unsigned int uiX,uiY,uiZ;
#ifdef DEBUG
// fSerialSendStr("sCycleSAM2()");

#endif

// Zaehlerstati auswerten auswerten
//if (ucStatusISR){
//   ucStatusISR |= 0x80;
iTemperatur = OW_GetTemperature();
uiX = uiMagSensor[0];
uiY = uiMagSensor[1];
uiZ = uiMagSensor[2];
   sprintf (tMSG_Buffer,"%lu;%i;%u;%u;%u", ulTime, iTemperatur, uiZ,uiY,uiX);
   ucStatusISR = 0;
   fSerialSendStr(tMSG_Buffer);

   // Lesen und Wandeln Temperatur
// 
#ifdef DEBUG
   //  Locale Bedienung 

// Zeitumrechnung

tNow.sec  = (unsigned int)  (ulTime         % 60);
tNow.min  = (unsigned int) ((ulTime /   60) % 60);
if ((ulTime %334) == 0) ulTime++;
tNow.hour = (unsigned int) ((ulTime / 3600) % 24);
//tNow.day  = (unsigned int) ((ulTime / 3600*24) % 365);

   //                                              1234567890123456 
   //  Displayausgabe Datum                        Date:   14-12-54
   //  Displayausgabe Uhrzeit                      Time:   20:15:00
   //  Displayausgabe2 Temperatursensor  Wert      Temp:     14.3C
   //  Displayausgabe2 Magnetsensor nr.  Wert      Flied X:   51300
//   sprintf(tMSG_Buffer,"Date:   %02i-%02i-%02i",tNow.day,tNow.month,tNow.year); fDisplay(1,tMSG_Buffer);
   sprintf(tMSG_Buffer,"Time: %02i:%02i:%02i",tNow.hour,tNow.min,tNow.sec);   fDisplay(1,tMSG_Buffer);
//   sprintf(tMSG_Buffer,"Temp:     %4.2f C",fTemperature);                       fDisplay(3,tMSG_Buffer);

   if ((PORTB & 0x0C) == 4){ 
      uiMagSensor[0] = uiCounterSAM2;
      sprintf(tMSG_Buffer,"Field X    %05u",uiMagSensor[0]); fDisplay(2,tMSG_Buffer);
	  }
   if ((PORTB & 0x0C) == 8){
      uiMagSensor[1] = uiCounterSAM2;
      sprintf(tMSG_Buffer,"Field Y    %05u",uiMagSensor[1]); fDisplay(2,tMSG_Buffer);
	  }
   if ((PORTB & 0x0C) == 0){
      uiMagSensor[2] = uiCounterSAM2;
      sprintf(tMSG_Buffer,"Field Z    %05u",uiMagSensor[2]); fDisplay(2,tMSG_Buffer);
	  }

#endif
//   } 

 
}


