/***********************************************************************/
/*                                                                     */
/* Name       : TCI_232.C           Version: 002.vpr              */
/*                                                                     */
/* Author     : Volker Pritsching                                      */
/*                                                                     */
/* Language   : C                                                      */
/*                                                                     */
/* Description: Communication interface for serial communication       */
/*              based on BCI_232.H from BIST_Software for mcb2         */
/*                                                                     */
/***********************************************************************/
/*                                                                     */
/* 18.07.04 V003 Volker Prisching RX ISR fr Atmel                     */
/*               Felherbehandlung gendert                             */
/***********************************************************************/
/***********************************************************************/
/* Imports                                                             */
/***********************************************************************/
#include <avr/io.h>
#include <avr/interrupt.h>

#include "SystemCore.h"

#undef DEBUG
/***********************************************************************/
/* Exports                                                             */
/***********************************************************************/
#include "System_RS232.h"
#define F_CPU 4000000UL	/* CPU clock in Hertz */
#define Baudrate 9600UL
/***********************************************************************/
/* Locals                                                              */
/***********************************************************************/
/*---------------------------------------------------------------------*/
/* Macros and defines                                                  */
/*---------------------------------------------------------------------*/
#define END_OF_SERIAL_STRING    0x0D    /* CR */
#define DEL                     0x7F
#define BACKSPACE               0x08
#define SOS                     0xFE    // start of record
#define RST                     0xFD    // reset LCD
#ifdef DEBUG 
  #define SOS                     0x40    // start of record
  #define RST                     0x41    // reset LCD
#endif
/*---------------------------------------------------------------------*/
/* Modulglobals                                                        */
/*---------------------------------------------------------------------*/
char t[COM_STRLEN_MAX+1];
char RX_Str_Ready;
char ucStrlen= 0;
static unsigned char ucInCount=0;
static unsigned char ucCount = 0;
/***********************************************************************/
/* Functions                                                           */
/***********************************************************************/
/***********************************************************************/
/*                                                                     */
/* Function   : fSerial_putchar()                                      */
/*                                                                     */
/* Description: transmits a character using ASC0, the serial port      */
/*              '\n'-Character is changed to '\r' (for Terminal-Program*/
/*                                                                     */
/* Return     : character which should be transmitted                  */
/*                                                                     */
/***********************************************************************/
char fSerial_putKey
(
  char c            // IMP: character to send
){

  loop_until_bit_is_set(UCSRA, UDRE);
 // if(c=='\n') cI = '\r';
 // else           cI = c;
  UDR = c;
return c;
}

char fSerial_putchar
(
  char c            // IMP: character to send
){

  loop_until_bit_is_set(UCSRA, UDRE);
 // if(c=='\n') cI = '\r';
 // else           cI = c;
//  UDR = c;
return c;
}
/***********************************************************************/
/*                                                                     */
/* Function   : fSerial_getkey()                                       */
/*                                                                     */
/* Description: receives a character using ASC0, the serial port       */
/*                                                                     */
/* Return     : received character                                     */
/*                                                                     */
/***********************************************************************/
char fSerial_getkey(void)
{
unsigned char c;
unsigned char s;
  s = UCSRA;
  c = UDR;
  if (s & 0x1C){
    fSerialInit(t);
    }
  return (c);
}
/***********************************************************************/
/*                                                                     */
/* Function   : fSerialInit()                                          */
/*                                                                     */
/* Description: inits the RS232 communication - only local parameters  */
/*                                                                     */
/* Return     : 0 = no errror                                          */
/*              1 = communication error                                */
/*                                                                     */
/***********************************************************************/
unsigned short fSerialInit
(
  char  *pcParm  // IMP: parameter string (not used)
)                // base auto detect: 
{	/* initialize UART1 */
pcParm = 0;

#define UART_UBRR_CALC(BAUD_,FREQ_) ((FREQ_)/((BAUD_)*16L)-1)

  UCSRB = _BV(TXEN)|_BV(RXEN)|_BV(RXCIE); /* tx/rx enable, rx complete intr */
  UCSRC = (1 << URSEL) | (3 << UCSZ0); 
  UBRRH = 0;
  UBRRL = F_CPU / (16L * Baudrate) - 1;  /* 9600 Bd */
RX_Str_Ready = 0;
ucStrlen= 0;
return 0;
}
/***********************************************************************/
/*                                                                     */
/* Function   : fSerialChange()                                        */
/*                                                                     */
/* Description: changes the communication parameter,                   */
/*                                                                     */
/* Return     : 0: no error                                            */
/*                                                                     */
/***********************************************************************/
unsigned short fSerialChange(void)
{
return NO_ERR;
}

/***********************************************************************/
/*                                                                     */
/* Function   : fSerialSendStr()                                       */
/*                                                                     */
/* Description: sends a string via serial interface (RS232)            */
/*              For this transmit direction no software handshake      */
/*                                                                     */
/* Return     : 0 = no errror                                          */
/*              COM_ERR = got NULL-Pointer or String too long,         */
/*              COM_STRLEN_MAX characters                              */
/*                                                                     */
/***********************************************************************/
unsigned short fSerialSendStr
(
  char *pc            // IMP: string to be send over the RS232
){
unsigned short ush;
ush = fSerialPureSend(pc);
fSerial_putchar(END_OF_SERIAL_STRING);
return ush;
}
/***********************************************************************/
/*                                                                     */
/* Function   : fSerialPureSend()                                      */
/*                                                                     */
/* Description: sends a string via serial interface (RS232)            */
/*              For this transmit direction no software handshake      */
/*                                                                     */
/* Return     : 0 = no errror                                          */
/*              COM_ERR = got NULL-Pointer or String too long,         */
/*              COM_STRLEN_MAX characters                              */
/*                                                                     */
/***********************************************************************/
unsigned short fSerialPureSend
(
  char *pc            // IMP: string to be send over the RS232
){
unsigned char uc;
if(pc==NULL) return COM_ERR;
for(uc=ucCOM_STRLEN_MAX; uc && *pc; uc--) fSerial_putchar(*pc++);
if(*pc) return COM_ERR;    // string was too long
else return NO_ERR;
}
/***********************************************************************/
/*                                                                     */
/* Function   : fSerialReceiveStr()                                    */
/*                                                                     */
/* Description: reads a command string from the RS232.                 */
/*   control until a string is received.                               */
/*  Each command string has to be terminated with END_OF_SERIAL_STRING */
/*  To make sure no data are lost the transmitter (=testsytem, terminal)*/
/*  there is a simple handshake. The transmitter has to wait for this echo*/
/*    before sending an new charakter.                                 */
/*                                                                     */
/* Return     : 0 = no errror                                          */
/*              1 = communication error                                */
/*                                                                     */
/***********************************************************************/

unsigned short fSerialReceiveStr
(
  char *pc      // EXP: string buffer  (max 80)
){
if (RX_Str_Ready){
  // copy input string to TSFW buffer, ucCount will be reset to 0
  ucCount--;  // the character END_OF_SERIAL_STRING is not part of input string
  pc[ucCount] = '\0';
  while(ucCount){
    ucCount--;
    pc[ucCount] = t[ucCount];
    RX_Str_Ready =0;
    ucStrlen= 0;
    }
  return NO_ERR;
  }
else return COM_NOT_FINISHED;   // there is no full command input
}

/**********************************************************************/

// interrupt 


ISR(USART_RXC_vect)
{
unsigned char ucBuff;
ucBuff = fSerial_getkey();
if(ucCount > COM_STRLEN_MAX){
  ucCount = 0;    // reset for next input string
  }
if (RX_Str_Ready ==1){
    RX_Str_Ready = 0;
    ucInCount = 0;
    ucCount =0;   // reset for next input string
    }
switch (ucBuff){
  case RST: 
    strcpy (t,":INIT\r");
    ucInCount = 0;
    ucCount=6;
    RX_Str_Ready = 1;
    break;
  case SOS: 
  strcpy (t,":wl 1 1 Volker__________\r");
    ucInCount = 0;
    ucCount = 5;
    break;
  default:
    t[ucCount] = ucBuff;                 // save char
	if (ucBuff == 0x20) {t[ucCount] = '_'; t[4] = 0x30;}     // if Blank in Zeile 
    ucCount++;
    break;
  }
if (ucCount == 8) {
  ucInCount = ucBuff + 8;    
    }
  
if (ucCount == ucInCount){
  t[5] = 0x20;
  t[6] = 0x30;
  t[7] = 0x20;
  t[24] = 0x0d;
  ucCount =25;
  RX_Str_Ready = 1; 
  }
}
