/*************************************************************************/
/*                                                                       */
/* Name       : Atmega_dog.c             Version in project: 001                */
/*                                              // !!! update please !!! */
/* Author     : Volker Pritsching                                        */
/*                                                                       */
/* Language   : C                                                        */
/*                                                                       */
/* Description: LCD Treiber fuer DOG Sertie  001 vpr                             */
/*              Treiber fuer eine LCD Anzeige                             */
/*                                                                       */
/*************************************************************************/
/*                                                                       */
/* 14.11.03 001 Volker Pritsching  first code      !!! update please !!! */
/* 14.8.05  002 Returnvalue init added                                   */
/* 4.10.2005 003 Portiert to Atmel ATMega8515                            */
/* 4.03.2008 004 Portiert to Atmel mit DOG M Anzeige                            */
/*************************************************************************/
/* Imports                                                                */

#define DataPort PORTA
#define AZEN PC0
#define AZRS PC2
#define AZRW PC1
#define bIn  PA7
//#define PWM_CONTRAST PD3
//#define PWM_Background PD4
/*************************************************************************/
#include <inttypes.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/sleep.h>

#include "SystemGlobals.h"


#include <stdio.h>
#include <string.h>


unsigned char fDisplay (unsigned char ucZeile, char* disp_buffer);
void fSerialSendStr ( char* disp_buffer);

/*************************************************************************/
/* Exports                                                               */
/*************************************************************************/
unsigned char ucLCD_available;           /* Gobal Hardwareflag           */
unsigned char ucLCD_Type = 0xF3;            /* Gobal flag lcd 8Bit par      */
unsigned char fDisplay(unsigned char ucLine, char* disp_buffer);
/*************************************************************************/
/* Locals                                                                */
/*************************************************************************/
unsigned char busy();
unsigned char fLCD_init (unsigned char);
/*************************************************************************/
/*                                                                       */
/* Function   : fLCDinit                                                 */
/*                                                                       */
/* Description: Init-Function for Display function                       */
/*                                                                       */
/* Return     : display available                                        */
/*                                                                       */
/************************************************************************/
#include "CharakterSet.h"

unsigned char fLCDInit(void)
{
if ((ucLCD_available = fLCD_init(ucLCD_Type)) == NO_ERR);{ 

#ifdef DEBUG
fSerialSendStr("fLCDInit (aviailable)");
#endif
  fDisplay(1," AVR Steuerung  ");
  fDisplay(2,"V.P. @2004/2008 ");
//  OCR1A = 200;
//  OCR1B = 200;      
  }
return(ucLCD_available);
}
/*************************************************************************/
/* Copyright: 			Volker Pritsching                                */
/* Datum Ersterstellung:23.11.2001                                       */
/* Zielhardware: 		uP Fujitsu 90xxx                                 */
/* Headerfile: 			lcd.h                                            */
/* Parameter:           Ausagbeport und Bits                             */
/*************************************************************************/
/*       anzeige_init: initialize anzeige interface                      */
/*************************************************************************/
void WriteOnce(unsigned char mode, unsigned char byte){
   PORTC &= ~((1<<AZEN)|(1<<AZRS)|(1<<AZRW));//  AZEN = 0; AZRS = 0; AZRW = 0;
   if (mode)   PORTC |=  ((1<<AZRS));        //  AZRS = 1 ==> Data
   PORTA  =  byte;                           //  erweiteret mode Dog
   PORTC |=  (1<<AZEN);                      //  AZEN = 1;
   PORTC |=  (1<<AZEN);                      //  AZEN = 1;
   PORTC &= ~(1<<AZEN);                      //  AZEN = 0;
}

void Delay27u (unsigned int time){
unsigned char L;

do {
  L =0; do { L +=1; } while (L < 101);
  } while (time-- > 0);

}

void writeByteSerial( unsigned char ucMode, unsigned char byte){
#define CSN 5
char i=0;
PORTA |= 0x40;                                // clock = 1                                
PORTC |= ((1<<AZEN)|(1<<AZRS)|(1<<AZRW));     // AZEN = 1; AZRS = 1; AZRW = 1;
if (ucMode == 0)   PORTC &=  ~((1<<AZRS));    // AZRS = 0 ==> command
PORTA &= ~ (1 << CSN);                        // chip select = 0
do {
  if ((byte & 0x80) == 0) PORTA &= ~0x80;
  else PORTA |= 0x80;
  PORTA &= ~0x40;
  i+=1;byte = byte << 1;
  PORTA |=  0x40;
  } while (i<8);

PORTA |= (1<<CSN);

}
/*************************************************************************/
/* local Subroutine wait until LCD ready                                 */
/* after 250 tries return with error            azd7 P2.6                */
/*************************************************************************/
unsigned char busy()
{
unsigned short usCounter = 25000;
unsigned char  ucBusy = 0x80;
DDRA &= ~(1<<PA7) ;    /* PA7 Busybit  als Eingaenge */
  do{

  PORTC &= ~((1<<AZEN)|(1<<AZRS));          //  AZEN = 0; AZRS = 0;
  PORTC |=  (1 <<AZRW);                     //  AZRW = 1;
  PORTC |=  (1<<AZEN);                      //  AZEN = 1;
//  PORTC |=  (1<<AZEN);                      //  AZEN = 1;
  ucBusy = PINA;                            //    bIn = AZD7;
  PORTC &= ~(1<<AZEN);                      //  AZEN = 0;
    usCounter --;
  }while(((ucBusy & 0x80) ==0x80 ) && (usCounter != 0));
  DDRA |= (1<<PA7) ;    /* PA7 Busybit  als Ausgang */
  if (usCounter == 0) return(HWMISSING_ERR);
return(NO_ERR);
}
/*************************************************************************/
/* local Subroutine write Command                                        */
/* if LCD not ready return with error                                    */
/*************************************************************************/
unsigned char write_CMD (unsigned char cmd){
  unsigned char ucStatus;
 switch (ucLCD_Type){
  case 0xf3:
    writeByteSerial(0,cmd);
    break;
  default:
    if ((ucStatus  = busy()) == HWMISSING_ERR) return (HWMISSING_ERR);
    WriteOnce (0,cmd);
	break;
	}
  return(NO_ERR);
  } 
/*************************************************************************/
/* local Subroutine write Data                                           */
/* if LCD not ready return with error                                    */
/*************************************************************************/
unsigned char write_Data (unsigned char dat){
 unsigned char ucStatus;
 switch (ucLCD_Type){
  case 0xf3:
    writeByteSerial(1,dat);
    break;
 default:
  if ((ucStatus = busy()) == HWMISSING_ERR) return (HWMISSING_ERR);
  WriteOnce(1,dat);
  break;
  }
  return (NO_ERR);} 
/*************************************************************************/
/* Public Subroutine INIT der Anzeige                                    */
/* if LCD not ready return with error                                    */
/*************************************************************************/


unsigned char fLCD_init (unsigned char ucMode)
{
unsigned short usCounter; 
unsigned char ucStatus; 

Delay27u (1480);         // wait 40ms after power up
switch (ucMode) {
  case 0x43:              //  4Bit 3V
   WriteOnce (0,0x30);   // 8bit 
   Delay27u (74);        // wait 2 ms
   WriteOnce (0,0x30);   // 8bit 
   Delay27u (1);         // wait 30us
   WriteOnce (0,0x30);   // 8bit 
   Delay27u (1);         // wait 30 ms
   if ((ucLCD_available = busy ()) == HWMISSING_ERR ) return HWMISSING_ERR;
   WriteOnce (0,0x20);   // 4 Bit mode 
   Delay27u (1);
   write_CMD (0x29);      // 6 bit 2 lines extended code table 1
   Delay27u (1);
   write_CMD (0x14);      // extended code bais 1/5, 2zeilig
   Delay27u (1);
   write_CMD (0x55);      // extended code booster on, constast c5,c4
   Delay27u (1);
   write_CMD (0x6d);      // extended code spannungsfolger und verstaerker 
   Delay27u (1);
   write_CMD (0x78);      // extended code contrasr c3, c2, c1 
   Delay27u (1);
   write_CMD (0x28);      // end extended code table 
   Delay27u (1);
   break;
  case 0x45:               // 4Bit 5V
   WriteOnce (0,0x30);   // 8bit 
   Delay27u (74);        // wait 2 ms
   WriteOnce (0,0x30);   // 8bit 
   Delay27u (1);         // wait 30us
   WriteOnce (0,0x30);   // 8bit 
   Delay27u (1);         // wait 30 ms
   if ((ucLCD_available = busy ()) == HWMISSING_ERR ) return HWMISSING_ERR;
   WriteOnce (0,0x20);   // 4 Bit mode 
   Delay27u (1);
   write_CMD (0x29);      // 4 bit 2 lines extended code table 1
   Delay27u (1);
   write_CMD (0x1c);      // extended code bais 1/4 2zeilen 
   Delay27u (1);
   write_CMD (0x52);      // extended code booster on, constast c5,c4
   Delay27u (1);
   write_CMD (0x69);      // extended code spannungsfolger und verstaerker 
   Delay27u (1);
   write_CMD (0x74);      // extended code contrasr c3, c2, c1 
   Delay27u (1);
   write_CMD (0x28);      // end extended code table 
   Delay27u (1);
   break;
   case 0x83:              // 8Bit 3V
   WriteOnce (0,0x38);   
   Delay27u (1);
   WriteOnce (0,0x39);   // 8bit 2 lines extended code table 1
   Delay27u (1);
   write_CMD (0x14);      // extended code bais 1/5, 2zeilig
   Delay27u (1);
   write_CMD (0x56);      // extended code booster on, constast c5,c4
   Delay27u (1);
   write_CMD (0x6d);      // extended code spannungsfolger und verstaerker 
   Delay27u (1);
   write_CMD (0x78);      // extended code contrasr c3, c2, c1 
   Delay27u (1);
   write_CMD (0x38);   // end extended mode dog serie
   Delay27u (1);
   break;
  case 0x85:              // 8Bit 5V
   WriteOnce (0,0x38);   
   Delay27u (1);
   WriteOnce (0,0x39);   // 8bit 2 lines extended code table 1
   Delay27u (1);
   write_CMD (0x1c);      // extended code bais 1/4 2zeilen 
   Delay27u (1);
   write_CMD (0x52);      // extended code booster on, constast c5,c4
   Delay27u (1);
   write_CMD (0x69);      // extended code spannungsfolger und verstaerker 
   Delay27u (1);
   write_CMD (0x74);      // extended code contrasr c3, c2, c1 
   Delay27u (1);
   write_CMD (0x38);      // end extended code table 
   Delay27u (1);
   break;
  case 0xf3:              // seriell 3v
//while(1){
   writeByteSerial(0,0x40);
   Delay27u (1);
   writeByteSerial(0,0xA1);
//   Delay27u (1);
   writeByteSerial(0,0xC0);
//   Delay27u (1);
   writeByteSerial(0,0xA6);
//   Delay27u (1);
   writeByteSerial(0,0xA2);
//   Delay27u (1);
   writeByteSerial(0,0x2F);
//   Delay27u (1);
   writeByteSerial(0,0xF8);
//   Delay27u (1);
   writeByteSerial(0,0x00);
//   Delay27u (1);
   writeByteSerial(0,0x27);
//   Delay27u (1);
   writeByteSerial(0,0x81);
//   Delay27u (1);
   writeByteSerial(0,0x16);
//   Delay27u (1);
   writeByteSerial(0,0xAC);
//   Delay27u (1);
   writeByteSerial(0,0x00);
 //  Delay27u (1);
   writeByteSerial(0,0xAF);
//   Delay27u (1);
//   }
  break;
 default:
    break;
  }
for(usCounter=0; usCounter <= 5000; usCounter++);
if ((ucLCD_available = busy ()) == HWMISSING_ERR ) return HWMISSING_ERR;
if ((ucStatus = write_CMD(0x0E)) == HWMISSING_ERR) return HWMISSING_ERR;
if ((ucStatus = write_CMD(0x06)) == HWMISSING_ERR) return HWMISSING_ERR;
return NO_ERR;
}
/*************************************************************************/
/* Public Subroutine fDisplay                                            */
/* Ausgabe einer Zeichenkette im displaybuffer                           */
/*************************************************************************
unsigned char fDisplay (unsigned char ucZeile, char* disp_buffer){
unsigned char usCounter;
unsigned char ucStatus; 
  if (ucLCD_available == HWMISSING_ERR) return(HWMISSING_ERR);
  if (ucZeile <5) ucZeile *= 0x10;
  switch (ucZeile & 0x0f){
     case 10:write_CMD (0x80+(ucZeile & 0x0f)); break;// Schreibpos Zeile 1
     case 20:write_CMD (0xC0+(ucZeile & 0x0f)); break;// Schreibpos Zeile 2
     case 30:write_CMD (0x90+(ucZeile & 0x0f)); break;// Schreibpos Zeile 3
     case 40:write_CMD (0xD0+(ucZeile & 0x0f)); break;// Schreibpos Zeile 4
     default:
      write_CMD (ucZeile);  // if Groesser 50 direkt mode
	  return(NO_ERR);
      break;
    }
  usCounter=0;
  while(disp_buffer[usCounter] != 0) 
    ucStatus = write_Data (disp_buffer[usCounter++]);
  return(NO_ERR);
}
*/
unsigned char fDisplay (unsigned char ucZeile, char* disp_buffer){
unsigned char usCounter;
unsigned char ucStatus; 
unsigned char h,l,p,c =0;
int i;

switch (ucLCD_Type){
  case 0xf3:
    write_CMD (0x40 );                         // Start Diplay ram
    write_CMD (0xA6 );							// Display on 
    if (ucZeile <5) ucZeile *= 0x10;            
	p = ucZeile >> 4 ;
    l = (ucZeile & 0x0f)  / 2;                  // adresse high * 8 / 16;
    h = (ucZeile & 0x0f)  % 2;                  // adresse low
    write_CMD (0xB0 | p);                       // setzte Zeile
    write_CMD (0x10 | h);    
    write_CMD (0x00 | l);    
    write_CMD (0xB2);                       // setzte Zeile
    usCounter=0;
    do { 
      i = (int) disp_buffer[usCounter++];
	  sprintf(tMSG_Buffer,"Byte %02x ",i); fSerialSendStr(tMSG_Buffer);
//      for (l =0; l<8; l++) write_Data(cChar128[i]); 
//      for (l =0; l<8; l++) write_Data(cChar128[i+l]); 
      } while(i != 0);
    break;
 default:
  if (ucLCD_available == HWMISSING_ERR) return(HWMISSING_ERR);
  if (ucZeile <5) ucZeile *= 0x10;
  if ((ucZeile & 0xf0)==0x50) {                    // setzen cursor on/off
      write_CMD (0x80+(ucZeile & 0x0f));
      write_CMD (0x0f);
	  return(NO_ERR);
	  }
  switch (ucZeile >> 4){
    case 1:  write_CMD ((ucZeile & 0x0f) |0x80);    break;               // Schreibpos Anfang Zeile 1
    case 2:  write_CMD ((ucZeile & 0x0f) |0xC0);    break;               // Schreibpos Anfang Zeile 2
    case 3:  write_CMD ((ucZeile & 0x0f) |0x90);    break;               // Schreibpos Anfang Zeile 3
    case 4:  write_CMD ((ucZeile & 0x0f) |0xD0);    break;               // Schreibpos Anfang Zeile 4
    default: write_CMD (ucZeile); break;               // if Groesser 50 direkt mode
    }
  usCounter=0;
  while(disp_buffer[usCounter] != 0) 
   ucStatus = write_Data (disp_buffer[usCounter++]);
   break;
   }
return(NO_ERR);
}
unsigned char fFillRAM (unsigned char p, unsigned char* disp_buffer){
unsigned char h,l,r,c =0;
   write_CMD (0x40 );
   write_CMD (0xA6 );
//    for (p=0; p<8; p++){
    write_CMD (0xb0 + p);
    for (h = 0; h <8; h++){
	  write_CMD (0x10 +h);
	  for (r=0;r<2;r++){
	    for (l =0; l<8; l++){
  	      write_CMD (0x00+l+ (0x08*r));
	      write_Data(disp_buffer[l]);
		  }
	  	}
      }
//   }
//while(1);
return(NO_ERR);
}

unsigned char fCharRAM (unsigned char ucZeichen, unsigned char* disp_buffer){
unsigned char usCounter =0;
unsigned char ucStatus; 
  if (ucLCD_available == HWMISSING_ERR) return(HWMISSING_ERR);
  write_CMD ((ucZeichen*8) |0x40);               // Schreibpos Anfang Zeile 4
  for (usCounter = 0;usCounter <8; usCounter++) write_Data (disp_buffer[usCounter]);
return(NO_ERR);
}
