/********************************************************************/
/*                                                                  */
/* Name       : ATmega128_tsfw.c          Version: 001.vpr            */
/*                                                                  */
/* Author     : Volker Pritsching                                   */
/* template   : by Gerhard Ort                                      */
/*                                                                  */
/* Language   : C                                                   */
/*                                                                  */
/* Description: FW template                                         */
/*              Standard Fujitsu functions                          */
/*                                                                  */
/*                                                                  */
/********************************************************************/
/*                                                                  */
/* 14.4.07 V001
      http://www.roboternetz.de/wissen/index.php/RC5-Decoder_f%C3%BCr_ATMega  */
/*               from BIST_Software for mcb2, STATE004              */
/* 14.04.07 V001 Volker Pritsching angepasst an die testsoftware    */
/********************************************************************/


/********************************************************************/
/* Imports                                                          */
/********************************************************************/
#include <stdio.h>
#include <string.h>

#include <avr/io.h>
#include <avr/interrupt.h>

#include <SystemSerialInterface.h>

unsigned char OW_ReadDeviceAdress( char *DeviceAddress);
void OW_ReadScratchMemory (unsigned char *buffer);

/* ******************************************************************************** */ 

extern unsigned char tMSG_Buffer[];

/* ******************************************************************************** */ 

typedef union { 
   unsigned int w; 
   unsigned char ucB[2];
   } code_t; 
   

/* ******************************************************************************** */ 
/*                                                                                  */
/*  OneWire Delay                                                                   */
#define DataLineInput  DDRA  &= ~0x01
#define DataLineOutput DDRA  |=  0x01
#define DataLineLow    PORTA &= ~0x01           // Data 0
#define DataLineHigh   PORTA |=  0x01           // Data 1
#define DataIn         PINA & 0x01

void OW_Delay (unsigned int ucTicks){

int i;

 for (i=0;i<ucTicks; i++);

}
/* ******************************************************************************** */ 
/*                                                                                  */
/*  OneWire Reset                                                                   */
/*                                                                                  */
/* ******************************************************************************** */ 
unsigned char OW_Reset (void) { 

DataLineOutput;
DataLineLow;                  // Data 0
OW_Delay (84);                // wait 480 us Constanttime + n * loop
DataLineHigh;                 // Data 1
DataLineInput;
OW_Delay(10);                 // wait 70 us for respones
//PORTD ^= 0x80;
if (DataIn) {
//   PORTD ^= 0x80;
   return(1);                 // OW not available;
   }    
//PORTD ^= 0x80;
OW_Delay(74);                 // wait 420 us for finish
return (0);                   // OW_available;

}
/* ******************************************************************************** */ 
/*                                                                                  */
/*  OneWire Read Bit                                                                */
/*                                                                                  */
/* ******************************************************************************** */ 
unsigned char OW_ReadBit (void){
unsigned char i;
DataLineOutput;
DataLineLow;
DataLineHigh;		 // IO Input
DataLineInput;
for (i=0;i<3;i++);   // wait 15us
if (DataIn) {
//   PORTD ^= 0x80;
   return(1); 
   }    
//PORTD ^= 0x80;
return (0);
}
/* ******************************************************************************** */ 
/*                                                                                  */
/*  OneWire Write Bit                                                               */
/*                                                                                  */
/* ******************************************************************************** */ 
void OW_WriteBit (unsigned char ucValue){
DataLineOutput;
DataLineLow;                  // Data 0
if (ucValue )  DataLineHigh;     //DAta =1
OW_Delay (16);         // 104 us
DataLineHigh;         // Data 1
DataLineInput;
}
/* ******************************************************************************** */ 
/*                                                                                  */
/*  OneWire Read Byte                                                               */
/*                                                                                  */
/* ******************************************************************************** */ 
unsigned char OW_ReadByte(void) {
unsigned char i;
unsigned char ucValue =0;
for (i=0;i<8;i++){
  if (OW_ReadBit()) ucValue|= 0x01 <<i; 
  OW_Delay(19);
  }
//  sprintf(tMSG_Buffer,"0x%02x",ucValue); fSerialSendStr(tMSG_Buffer);

return (ucValue);
}
/* ******************************************************************************** */ 
/*                                                                                  */
/*  OneWire Write Byte                                                              */
/*                                                                                  */
/* ******************************************************************************** */ 
void OW_WriteByte (char ucValue) {
unsigned char i;
unsigned char ucTemp;
for (i=0;i<8;i++){
  ucTemp = ucValue >>i;
  ucTemp &=0x01;
//PORTD ^= 0x40;
  OW_WriteBit(ucTemp);
  }
OW_Delay(16);
}
/* ******************************************************************************** */ 
/*                                                                                  */
/*  Hight Level Routines.                                                           */
/*                                                                                  */
/* ******************************************************************************** */ 

unsigned char OW_ReadDeviceAddress( char *DeviceAddress){
int i;

if (OW_Reset() ==0) {
  OW_WriteByte(0x33);
  for (i=0;i<8;i++){
    DeviceAddress[i] = OW_ReadByte();
	}
  return (0);
  }
return (1);                                      // device error
}

unsigned char OW_StartConversion(char *cDeviceAddress){
int i;

if (OW_Reset() ==0) {
  OW_WriteByte(0x55);
  for (i=0;i<8;i++){
     OW_WriteByte(cDeviceAddress[i]);
	}
  OW_WriteByte(0x44);
  return (0);
  }
return (1);                                      // device error
}
unsigned char OW_ReadDeviceMemory(char *cDeviceAddress, char *cSrcatchMemory){
int i;

if (OW_Reset() ==0) {
  OW_WriteByte(0x55);
  for (i=0;i<8;i++){
     OW_WriteByte(cDeviceAddress[i]);
	}
  OW_WriteByte(0xBE);
  for (i=0;i<9;i++){
    cSrcatchMemory[i] = OW_ReadByte();
    sprintf(tMSG_Buffer,"Data %i: 0x%02X",i, cSrcatchMemory[i]); fSerialSendStr(tMSG_Buffer);
	}
  return (0);
  }
return (1);                                      // device error
}

int OW_GetTemperature(void){
int iT,i;

  if (OW_Reset() ==1) return(0x8000);
  OW_WriteByte(0xCC);
  OW_WriteByte(0x44);
  while ( OW_ReadBit() == 0);
  if (OW_Reset() ==1) return(0x8000);
  OW_WriteByte(0xCC);
  OW_WriteByte(0xBE);
  i   = (unsigned int) OW_ReadByte();
  iT  = ((unsigned int) OW_ReadByte() << 8) + i;
  OW_Reset(); 
  return((int) iT);
}







