/********************************************************************/
/*                                                                  */
/* Name       : ATmega128_tsfw.c          Version: 001.vpr            */
/*                                                                  */
/* Author     : Volker Pritsching                                   */
/* template   : by Gerhard Ort                                      */
/*                                                                  */
/* Language   : C                                                   */
/*                                                                  */
/* Description: FW template                                         */
/*              Standard Fujitsu functions                          */
/*                                                                  */
/*                                                                  */
/********************************************************************/
/*                                                                  */
/* 21.09.98 V001 Gerhard Ort File created, based on MCB_BIST.C      */
/*               from BIST_Software for mcb2, STATE004              */
/* 19.01.04 V001 Programm used as Template for Fujitsi 90497        */
/********************************************************************/
#define CycleLED PORTA,0

/********************************************************************/
/* Imports                                                          */
/********************************************************************/
#include <avr/io.h>
#include <avr/interrupt.h>
#include <stdio.h>
#include <string.h>
#include "ATMEGA_CLK.h"
#include "SYSTEMCORE.h"
#include "SYSTEMSERIALINTERFACE.h"
#include "ATMEGA_TSFW.h"


char Status_Bus;
unsigned char ucClockUpdate;
unsigned char ucPreClock;

unsigned int uiTick;
unsigned char ucUpdateTimer;
/********************************************************************/
/*    prototypes                                                    */
/********************************************************************/
/********************************************************************/
/* Exports                                                          */
/********************************************************************/
unsigned short ushGlobal_MS_Timer;
char cycletime;
/*------------------------------------------------------------------*/
/* Prototypes of Functions for Command Interpreter Functions:       */
/*------------------------------------------------------------------*/
static unsigned short fReadMemByte (char *tParm);
static unsigned short fWriteMemByte (char *tParm);

#define setBit(Port,Bit) Port |= (1<< Bit)
#define clrBit(Port,Bit) Port &= ~(1<< Bit)
#define cplBit(Port,Bit) Port ^= (1<< Bit)

/*------------------------------------------------------------------*/
/*  Fujitsu functions                                               */
/*------------------------------------------------------------------*/
COM_DEF asATmega_ComDef [] =
{
	{":READ:MEM?",                   fReadMemByte},
	{":WRITE:MEM",                   fWriteMemByte},
	{NULL,                          NULL} // array must end with NULL,NULL
};
/********************************************************************/
/* Locals                                                           */
/********************************************************************/
#define TIMER_RELOAD_1MS  -625
static unsigned short ushTimerValue;
unsigned char ucRC5Timer;
/*------------------------------------------------------------------*/
/* Modul global variables                                           */
/*------------------------------------------------------------------*/
static volatile unsigned char ucCycleLedtime = 0;   // CycleLed rhythm
unsigned long int ulTime =0;                        // default is 0
static unsigned int uiPreClock;
/********************************************************************/
/*                                                                  */
/* Function   : fCycleLED_TimerISR()                                */
/*                                                                  */
/* Description: ISR, is called every 500s, controls the cycle LED  */
/*       the rhythm depends on global variable ucCycleLedtime       */
/*       ucCycleLedtime=0 => 10010000, ucCycleLedtime=1 => 11001100 */
/*       increments a timer variable                                */
/*                                                                  */
/* Return     : none                                                */
/*                                                                  */
/********************************************************************/
ISR (TIMER1_OVF_vect)		/* Note [2] */
{
	//PORTC ^= 0x10;		/for test only
}


ISR (TIMER0_OVF_vect)		// Interupt zyclisch aller 3990 s
{
	#define ticks 15
	#define PWM 25
//	extern unsigned int uiCounterFlux;
	static unsigned char ucPWM=0;
	PORTD ^= 0x20;
	if (ucPWM++ > 3) ucPWM =0;
	if (ucPWM   > 3) PORTD |= 0x10;
	else             PORTD &= (~0x10);
	switch (++uiPreClock){
		case 243:
		uiPreClock =0;
		ulTime++;
		ucClockUpdate =1;
		case 121:

		TCCR1B =0,                   // diable Count Input
		uiCounterFlux= TCNT1;        // read Counter Value
		if (uiCounterFlux ==0) {
			uiCounterFlux = 8000;
//sprintf(tMSG_Buffer, "v=%i", uiCounterFlux); fSerialSendStr(tMSG_Buffer);
		}
		switch (PORTB & 0X1C){
			case 0x00:		// next Channel 1: Port B: xxx0 01xx
			PORTB &= 0xE3;  
			PORTB |= 0x04;
			break;
			case 0x04:		// next Channel 2: Port B: xxx0 10xx      
			PORTB &= 0xE3;
			PORTB |= 0x08;
			break;
			case 0x08:		// next Channel 3: Port B: xxx0 11xx
			PORTB &= 0xE3;
			PORTB |= 0x0c;
			break;
			case 0x0c:		// next Channel 4: Port B: xxx1 00xx
			PORTB &= 0xE3;
			PORTB |= 0x10;
			break;
			case 0x10:		// next Channel 5: Port B: xxx1 01xx
			PORTB &= 0xE3;
			PORTB |= 0x14;
			break;
			case 0x14:		// next Channel 0: Port B: xxx0 00xx
			default:
			PORTB &= 0xE3;
			break;
		}
		TCNT1 = 0;                   // reset Counter
		TCCR1B = 0x07;               // start Count
		break;
		default:
		break;
	}
	if (++uiTick == 50) { uiTick =0; ucUpdateTimer =1;}
	static unsigned char ucOutputState=0;
	static unsigned short ushLastStateChangeTime=0;

	cycletime   = cycletime +1;
	ushTimerValue++;      //increment timer variable

	ushGlobal_MS_Timer++;
	switch(ucOutputState)
	{
		case 0:
		setBit(PORTB,0);                          // Cycle LED on
		// wait approxymately 60ms (ticks) or 120ms
		
		if(ushTimerValue - ushLastStateChangeTime >= ticks + ucCycleLedtime*ticks)
		{
			ucOutputState++;
			ushLastStateChangeTime = ushTimerValue;
		}

		break;
		case 1:
		clrBit(PORTB,0);                          // Cycle LED off
		// wait approxymately 120ms
		if(ushTimerValue - ushLastStateChangeTime >= 2*ticks)
		{
			ucOutputState++;
			ushLastStateChangeTime = ushTimerValue;
		}

		break;
		case 2:
		setBit(PORTB,0);                          // Cycle LED on
		// wait approxymately 60ms or 120ms
		
		if(ushTimerValue - ushLastStateChangeTime >= ticks + ucCycleLedtime*ticks)
		{
			ucOutputState++;
			ushLastStateChangeTime = ushTimerValue;
		}

		break;
		default:
		clrBit(PORTB,0);                          // Cycle LED off
		// wait approxymately 240ms or 120ms
		if(ushTimerValue - ushLastStateChangeTime >= 2*ticks + (1-ucCycleLedtime)*2*ticks)
		{
			ucOutputState = 0;
			ushLastStateChangeTime = ushTimerValue;
		}

		break;
	}
	
}
/********************************************************************/
/*  Functions  fr Handbox                                          */
/********************************************************************/
void fInitIOPorts(void){
	DDRA  = 0xFF;  // all bits are Output Bus fr LCD
	DDRB  = 0xE7;  // MOSI Interface, key,key, kup, kup, Cyle LED
	PORTB = 0XF8;  // enable PULUPs
	DDRC  = 0x07;  // Key0 key1 Key2,key3, key4  LCD LCD LCD
	PORTC = 0xf8;  // enable all pullups
	DDRD  = 0x33;  // Key5,Key6, displa, display, test, ir, com 0
	PORTD = 0xC4;  // enable PULUPs
}
/********************************************************************/
void fInitTimer(void)
{
	//sytemtimer
	TCCR0 = 0x03; //normal mode of 8 bit timer 0
	//source fosz.
	TIMSK = _BV (TOIE0);


	TCNT1=0;
	//OCR1A   = 1000;                         // Set switch value constrast min 1024
	//OCR1A   = 500;                          // Set switch value constrast
	OCR1A   = 10;                           // Set switch value constrast max =0
	OCR1B   = 540;//600;                    // Set Switch value Backgroud
	TCCR1A  = 0xe3;                         // Contrast, background (fast PWM)
	TCCR1B  = 0x01;                         // Contrast, background (fast PWM)
	TIMSK  |= 0x04;
	}/********************************************************************/
	/*                                                                  */
	/* Function   : fATmega128_Init                                       */
	/*                                                                  */
	/* Description: Init-Function                                       */
	/*                                                                  */
	/* Return     : none                                                */
	/*                                                                  */
	/********************************************************************/
	void fATmega_Init(void){
		fInitIOPorts();
		cycletime   =  0;
		MCUCR = 0x00; // Interrupsense register
		fInitTimer();
		//	fInit_PWM();
		sei();
	}
	/*------------------------------------------------------------------*/
	/*                         Command- and Query- Functions            */
	/*------------------------------------------------------------------*/
	/********************************************************************/
	/*                                                                  */
	/* Function   : fReadMemByte()       > Query <                      */
	/*                                                                  */
	/* Description: reads one byte from memory                          */
	/*                                                                  */
	/* Return     : result string                                       */
	/*                                                                  */
	/********************************************************************/
	static unsigned short fReadMemByte
	(
	char *tParm           // IMP: parameter (string)
	)                       // parameter <Adr: 0..0xffffff>
	// base auto detect: 0xnn: hex,
	// 0nn: octal,
	// nn: decimal
	{
		long                lAdr;
		unsigned char       uc;

		fMakeStringReady4sscanf(tParm);
		if ( (sscanf (tParm, "%li", &lAdr) != 1)   // check for parm error
		|| (lAdr < 0 ) || (lAdr >= 0x1000000L) )
		{
			RETURN( PARM_ERR, "W0" );
		}

		// read byte and write to string
		uc = *pucXRAM(lAdr);
		sprintf (tMSG_Buffer, "memory byte: %u 0x%x", uc, uc);
		RETURN( NO_ERR, tMSG_Buffer );
	}
	/********************************************************************/
	/*                                                                  */
	/* Function   : fWriteMemByte()     > Command <                     */
	/*                                                                  */
	/* Description: writes one byte to memory                           */
	/*                                                                  */
	/* Return     : empty string                                        */
	/*                                                                  */
	/********************************************************************/
	static unsigned short fWriteMemByte
	(
	char *tParm         // IMP: parameter (string)
	)                     // parameter <Adr: 0..0xffffff> <Byte: 0..0xff>
	{
		long                lAdr;
		int                 iByte;

		fMakeStringReady4sscanf(tParm);
		if ( (sscanf (tParm, "%li%i", &lAdr, &iByte) != 2)
		|| (lAdr < 0 ) || (lAdr >= 0x1000000L)
		|| (iByte < 0) || (iByte > 255) )
		{
			RETURN( PARM_ERR, "Wrong Paranmeter" );
		}

		RETURN( NO_ERR, NULL );
	}
